class Ex1_19
parameter Real pi = Modelica.Constants.pi;

Real theta(unit="rad");/*angular position of the particle*/
Real r(unit="m");/*radial coordinate of the particle*/

Real x(unit="m");/*x-coordinate of the particle*/
Real y(unit="m");/*y-coordinate of the particle*/

Real theta_dot(unit="rad/s");/*1-st derivative of the angle*/
Real theta_ddot(unit="rad/s^2");/*2-nd derivative of the angle*/
Real r_dot(unit="m/s");/*1-st derivative of r*/
Real r_ddot(unit="m/s^2");/*2-nd derivative of r*/

Real v[2](each unit="m/s");/*velocity of the particle in polar coordinate*/
Real v_ana[2](each unit="m/s");/*analytcal equation for the velocity of the particle in polar coordinate*/

Real a[2](each unit="m/s^2");/*acceleration of the particle in polar coordinate*/
Real a_ana[2](each unit="m/s^2");/*analytical equation for the acceleration of the particle in polar coordinate*/

equation
theta=pi*time;
r=2*sin(3*theta);

x=r*cos(theta);
y=r*sin(theta);

theta_dot=der(theta);
theta_ddot=der(theta_dot);
r_dot=der(r);
r_ddot=der(r_dot);

v={r_dot,r*theta_dot};
v_ana={6*pi*cos(3*pi*time),2*pi*sin(3*pi*time)};

a={r_ddot-r*theta_dot^2,r*theta_ddot+2*r_dot*theta_dot};
a_ana={-20*pi^2*sin(3*pi*time),12*pi^2*cos(3*pi*time)};

end Ex1_19;
