class Ex1_28
parameter Real wide(unit="ft")=30;/*wide of the river*/
parameter Real route_length(unit="ft")=40;/*route length across the river*/
parameter Real v_w[2](each unit="ft/s")={0,-6};/*velocity vector of the water*/
parameter Real v_bw_mag(unit="ft/s")=10;/*magnitude of the velocity vector of the boat relative to the water*/

Real v_b(unit="ft/s");/*magnitude of the absolute velocity vector*/
Real beta(unit="rad");/*direction of the absolute velocity vector of the boat w.r.t. x-axis*/
Real e_b[2];/*unit vector along the absolute velocity vector*/
Real theta_rad(unit="rad");/* direction of the relative velocity v_w w.r.t. x-axis in radian unit*/
Real theta(unit="deg");/* direction of the relative velocity v_w w.r.t. x-axis in degree unit*/

Real V_L[2](each unit="ft/s");/*left hand side of the relative velocity equation*/
Real V_R[2](each unit="ft/s");/*left hand side of the relative velocity equation*/
equation
tan(beta)=route_length/wide;
e_b={cos(beta),sin(beta)};
V_L=v_b*e_b;
V_R=v_w+v_bw_mag*{cos(theta_rad),sin(theta_rad)};
V_L[1]=V_R[1];
V_L[2]=V_R[2];
theta=Modelica.SIunits.Conversions.to_deg(theta_rad);
end Ex1_28;
