class Ex2_11
parameter Real g(unit="ft/s^2")=32.2;/*acceleration due to gravity*/

parameter Real a_t(unit="ft/s^2")=5;/*tangential component of the acceleration of the car*/
Real a_n(unit="ft/s^2");/*normal component of the acceleration of the car*/
Real a(unit="ft/s^2");/*total acceleration of the car*/
Real v(unit="ft/s");/*velocity of the car*/
parameter Real mu=0.18;/*coefficient of static friction*/
parameter Real rho(unit="ft")=20;/*radius of curvature of the path*/
Real t(unit="s");/*time required to slide the book from dashboard*/
Real s(unit="ft");/*distance traveled along the arc*/
Real theta_rad(unit="rad");/*angular distance traveled by the car in radian unit*/ 
Real theta_deg(unit="deg");/*angular distance traveled by the car in degree unit*/

equation
v=a_t*t;
a_n=v^2/rho;
a=sqrt(a_t^2+a_n^2);
mu*g=a;
s=(a_t*t^2)/2 ;
rho*theta_rad=s;
theta_deg=Modelica.SIunits.Conversions.to_deg(theta_rad);
/*The  answer provided in the textbook is wrong*/
end Ex2_11;
