class Ex2_16
/*the stop time should be taken more than 3 seconds to get result*/
parameter Real m(unit="kg")=2;/*mass of the particle*/

Real r(unit="m");/*r-coordinate of the particle*/
Real theta(unit="rad");/*theta-coordinate of the particle*/
Real x(unit="m");/*x-coordinate of the particle*/
Real y(unit="m");/*y-coordinate of the particle*/
Real r_dot(unit="m/s");/*1st derivative of r*/
Real r_ddot(unit="m/s^2");/*2nd derivative of r*/
Real theta_dot(unit="rad/s");/*1st derivative of theta*/
Real theta_ddot(unit="rad/s^2");/*2nd derivative of theta*/
Real F_r(unit="N");/*component of force along r direction*/
Real F_theta(unit="N");/*component of force along theta direction*/
Real F(unit="N");/*total force*/
Real F_2(unit="N");/*total force at 2 seconds*/
equation
r=3-2*time+3*time^2;
theta=1+time^2;
x=r*cos(theta);
y=r*sin(theta);
r_dot=der(r);
r_ddot=der(r_dot);
theta_dot=der(theta);
theta_ddot=der(theta_dot);

F_r=m*(r_ddot-r*theta_dot^2);
F_theta=m*(2*r_dot*theta_dot+r*theta_ddot);
F=sqrt(F_r^2+F_theta^2);
when time>=2-0.02 and time<=2+0.02 then
F_2=F;
end when;

end Ex2_16;
