class Ex2_19
parameter Real pi = Modelica.Constants.pi;

parameter Real h_0(unit="m")=700*10^3;/*initial altitude of the satellite from the surface of earth*/
parameter Real R(unit="m")=6378*10^3;/*radius of the earth*/
Real r_0(unit="m");/*initial distance of the satellite from the center of earth*/
parameter Real v_0(unit="m/s")=10000;/*initial velocity of the satellite*/
parameter Real G(unit="m^3/(kg.s^2)")=66.73*10^(-12);/*gravitational constant*/
parameter Real M(unit="kg")=5.976*10^(24);/*mass of the earth*/
parameter Real theta_0(unit="rad")=0;/*initial angular position of the satellite*/
parameter Real theta_r_a(unit="rad")=pi;/*angular position of the satellite at maximum altitude*/
Real h(unit="m^2/s");/*angular momentum*/
Real C;/*constant*/
Real r_a(unit="m");/*maximum radial position*/
equation
r_0=h_0+R;
h=r_0*v_0;
1/r_0=C*cos(theta_0)+(G*M)/h^2;
1/r_a=C*cos(theta_r_a)+(G*M)/h^2;
/*The  answer may slightly vary due to  rounding off values*/
end Ex2_19;
