class Ex2_7
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real m(unit="kg")=20;/*mass of the block*/
parameter Real mu=0.3;/*coefficient of kinetic friction between the block and the surface*/

Real P[3](each unit="N");/*applied force on the block*/
Real W[3](each unit="N");/*weight of the block*/
Real N[3](each unit="N");/*normal force on the block*/
Real N_mag(unit="N");/*magnitude of the normal force on the block*/
Real F[3](each unit="N");/*friction force on the block*/
Real F_mag(unit="N");/*magnitude of the friction force on the block*/
Real AB[3];/*vector AB*/
Real AC[3];/*vector AC*/
Real n_hat[3];/*unit vector normal to the inclined plane*/
Real p_hat[3];/*unit vector in the P+W direction*/
Real p_n[3];/*component of p_hat in the normal direction of the inclined plane*/
Real p_t[3];/*component of p_hat in the tangential direction of the inclined plane*/
Real f_hat[3];/*unit vector for the friction force*/

Real a[3](each unit="m/s^2");/*acceleration of the particle*/
Real a_mag(unit="m/s^2");/*magnitude of the acceleration of the particle*/

parameter Real t(unit="s")=2;/*given time*/
parameter Real r_0[3](each unit="m")={3.5,5,0};/*initial position of the block*/
Real r[3](each unit="m");/*position of the block after 2 seconds*/

equation
P={-500,-300,0};
W={0,0,-m*g};
AB={(0-7),(0-0),(7-0)};
AC={(0-7),(10-0),(0-0)};

n_hat=cross(AC,AB)/Modelica.Math.Vectors.norm(cross(AC,AB));
p_hat=(P+W)/Modelica.Math.Vectors.norm(P+W);
p_n=sum(p_hat.*n_hat)*n_hat;
p_t=p_hat-p_n;
f_hat=-p_t/Modelica.Math.Vectors.norm(p_t);

N=N_mag*n_hat;
F_mag=mu*N_mag;
F=F_mag*f_hat;
a=-a_mag*f_hat;

P[1]+W[1]+N[1]+F[1]=m*a[1];
P[2]+W[2]+N[2]+F[2]=m*a[2];

r=(a*t^2)/2+r_0;
/*The  answer may slightly vary due to  rounding off values*/

end Ex2_7;
