class Ex3_1
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real m(unit="kg")=3;/*mass of the particle*/
parameter Real v_0(unit="m/s")=2;/*initial velocity of the particle*/
parameter Real v_f(unit="m/s")=0;/*final velocity of the particle*/
parameter Real theta_deg(unit="deg")=30;/*inclination of the plane in degree unit*/
Real theta_rad(unit="rad");/*inclination of the plane in radian unit*/
parameter Real mu=0.4;/*coefficient of kinetic friction*/
Real U_12(unit="J");/*work done by the forces*/
Real T_1(unit="J");/*initial kinetic energy of the particle*/
Real T_2(unit="J");/*final kinetic energy of the particle*/
Real N(unit="N");/*normal force between plane and particle*/
Real f(unit="N");/*frictional force*/
Real x(unit="m");/*distance traveled by the block before stop*/
equation
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);
U_12=-(m*g*sin(theta_rad)+f)*x;
T_2=(1/2)*m*v_f^2;
T_1=(1/2)*m*v_0^2;
N=m*g*cos(theta_rad);
f=mu*N;
U_12=T_2-T_1;
end Ex3_1;
