class Ex3_9
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real m_p(unit="kg")=3;/*mass of the package*/
parameter Real m_c(unit="kg")=10;/*mass of the cart*/
parameter Real theta_deg(unit="deg")=30;/*inclination of the plane in degree unit*/
Real theta_rad(unit="rad");/*inclination of the plane in radian unit*/
parameter Real s(unit="m")=5;/*length of the incline plane*/
Real h(unit="h");/*distance between base and initial position of the package*/
Real v(unit="m/s");/*velocity of the package at the end of the plane*/
Real v_px(unit="m/s");/*horizontal component of the velocity of the package at the end of the plane*/
Real v_f(unit="m/s");/*velocity of the cart and package*/
equation
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);
h=s*sin(theta_rad);
m_p*g*h=(1/2)*m_p*v^2;
v_px=v*cos(theta_rad);
m_p*v_px=(m_p+m_c)*v_f;
end Ex3_9;
