class Ex5_1
parameter Real r[3](each unit="inches")={4,3,5};/*position vector from the origin to point A*/
parameter Real w[3](each unit="rad/s")={0,0,2};/*constnat angular velocity of the ball*/
Real v[3](each unit="in/s");/*linear velocity of point A*/
Real v_mag(unit="in/s");/*magnitude of linear velocity of point A*/
Real alpha[3](each unit="rad/s^2");/*angular acceleration*/
Real a[3](each unit="in/s^2");/*total acceleration of point A*/
Real a_mag(unit="in/s^2");/*magnitude of total acceleration of point A*/
Real rho[3](each unit="inches");/*vector from the z-axis to point A*/
Real a_n[3](each unit="in/s^2");/*normal component of total acceleration of point A*/
Real k_hat[3];/*unit vector along k-direction*/
Real phi_rad(unit="rad");/*angle between posuion of point A and z-axis in radian unit*/
Real phi(unit="deg");/*angle between posuion of point A and z-axis in degree unit*/
equation
v=cross(w,r);
v_mag=Modelica.Math.Vectors.norm(v);
alpha={0,0,0};
a=cross(alpha,r)+cross(w,v);
a_mag=Modelica.Math.Vectors.norm(a);
rho={4,3,0};
a_n=-sum(w.*w)*rho;
k_hat={0,0,1};
cos(phi_rad)=sum(r.*k_hat)/Modelica.Math.Vectors.norm(r);
phi=Modelica.SIunits.Conversions.to_deg(phi_rad);


end Ex5_1;
