class Ex5_11
parameter Real v_Ax(unit="in/s")=10;/*component of velocity of A in x-direction*/
parameter Real v_By(unit="in/s")=-10;/*component of velocity of B in y-direction*/
parameter Real v_Cx(unit="in/s")=20;/*component of velocity of C in x-direction*/

parameter Real v_Az(unit="in/s")=0;/*component of velocity of A in z-direction*/
parameter Real v_Bz(unit="in/s")=0;/*component of velocity of B in z-direction*/
parameter Real v_Cz(unit="in/s")=0;/*component of velocity of C in z-direction*/

Real r_AB[3](each unit="in");/*position vector of point A relative to B*/
Real r_CB[3](each unit="in");/*position vector of point C relative to B*/

Real v_Ay(unit="in/s");/*component of velocity of A in y-direction*/
Real v_Bx(unit="in/s");/*component of velocity of B in x-direction*/
Real v_Cy(unit="in/s");/*component of velocity of C in y-direction*/

Real v_A[3](each unit="in/s");/*absolute velocity of point A*/
Real v_B[3](each unit="in/s");/*absolute velocity of point B*/
Real v_C[3](each unit="in/s");/*absolute velocity of point C*/

Real v_A_L[3](each unit="in/s");/*left hand of relative velocity equation of A*/
Real v_A_R[3](each unit="in/s");/*right hand of relative velocity equation of A*/
Real v_C_L[3](each unit="in/s");/*left hand of relative velocity equation of C*/
Real v_C_R[3](each unit="in/s");/*right hand of relative velocity equation of C*/

Real w_mag(unit="rad/s");/*magnitude of the angular velocity of boomerang*/
Real w[3](each unit="rad/s");/*angular velocity of boomerang*/
equation
r_AB={-1,8,0};
r_CB={8,-1,0};
w=w_mag*{0,0,1};

v_A={v_Ax,v_Ay,v_Az};
v_B={v_Bx,v_By,v_Bz};
v_C={v_Cx,v_Cy,v_Cz};

v_A_L=v_A;
v_C_L=v_C;

v_A_R=v_B+cross(w,r_AB);
v_C_R=v_B+cross(w,r_CB);

v_A_L[1]=v_A_R[1];
v_A_L[2]=v_A_R[2];

v_C_L[1]=v_C_R[1];
v_C_L[2]=v_C_R[2];


end Ex5_11;
