class Ex5_12
/*the stop time should be taken 9.4 seconds to get the result*/

parameter Real D(unit="m")=3;/*diameter of the cylinder*/
Real r(unit="m");/*radius of the cylinder*/
parameter Real v_c[3](each unit="m/s")={2,0,0};/*velocity of the center of the cylinder*/
parameter Real v_P[3](each unit="m/s")={0,0,0};/*velocity of the contact point P*/
Real v_P_R[3](each unit="m/s");/*right hand side of the velocity equation of the contact point P*/

Real w_mag(unit="rad/s");/*magnitude of the angular velocity of cylinder*/
Real w[3](each unit="rad/s");/*angular velocity of cylinder*/
Real r_Pc[3](each unit="m");/*positon vector of the point P relative to center c*/

Real theta(unit="rad");/*the angle through which the cylinder rotates*/
Real r_Bc[3](each unit="m");/*positon vector of the point B relative to center c*/

Real v_B[3](each unit="m/s");/*velcoty of point B*/

Real x(unit="m",start=0);/*x-coordinate of point B*/
Real y(unit="m",start=0);/*y-coordinate of point B*/
Real x_ana(unit="m");/*analytical expression for x-coordinate of point B*/
Real y_ana(unit="m");/*analytical expression for y-coordinate of point B*/

equation
r=D/2;
r_Pc={0,1.5,0};
w=w_mag*{0,0,1};
v_P_R=v_c+cross(w,r_Pc);
v_P[1]=v_P_R[1];

theta=w_mag*time;
r_Bc=r*{cos(w_mag*time),sin(w_mag*time),0};
v_B=v_c+cross(w,r_Bc);
der(x)=v_B[1];
der(y)=v_B[2];
x_ana=2*time+1.5*cos(1.333*time)-1.5;/*expression provided for x_ana in the book is wrong*/
y_ana=1.5*sin(1.333*time);
/*The  answer (graph between x and y) provided in the textbook is wrong*/
end Ex5_12;
