class Ex5_16
parameter Real r_A[3](each unit="m")={1.6,1.5,0};/*position vector of point A*/
parameter Real r_B[3](each unit="m")={2,1.8,0};/*position vector of point B*/
parameter Real v_A[3](each unit="m/s")={3,0,0};/*linear velocity vector of point A*/
parameter Real v_B[3](each unit="m/s")={2.4,0.8,0};/*linear velocity vector of point B*/

parameter Real a_A[3](each unit="m/s^2")={3,2,0};/*acceleration vector of point A*/
parameter Real a_B[3](each unit="m/s^2")={1.1,1.2,0};/*acceleration velocity vector of point B*/


Real r_BA[3](each unit="m");/*position of B relative to A*/
Real v_BA[3](each unit="m/s");/*velocity vector of B relative to A*/

Real w_mag(unit="rad/s");/*magnitude of the angular velocity velocity of the body*/
Real w[3](each unit="rad/s");/*angular velocity of the body*/
Real v_BA_wr[3](each unit="m/s");/*linaer velocity of B w.r.t to A from w and r_AB vector*/

/*1st Method*/
Real alpha1_mag(unit="rad/s^2");/*magnitude of angular acceleration*/
Real alpha1[3](each unit="rad/s^2");/*angular acceleration*/

/*2nd Method*/
Real e_BA[3];/*unit vector in the direction of r_BA*/
parameter Real k_hat[3]={0,0,1};/*unit vector along k-direction*/
Real e_t[3];/*unit vector in the tangential direction*/
Real a_BA[3](each unit="m/s");/*acceleration vector of B relative to A*/
Real alpha2_mag(unit="rad/s^2");/*magnitude of angular acceleration*/
Real alpha2[3](each unit="rad/s^2");/*angular acceleration*/
Real w_2[3](each unit="rad/s");/*angular velocty from Rodrigue's formula*/

/*3rd Method*/
Real alpha3[3](each unit="rad/s^2");/*angular acceleration*/
equation
r_BA=r_B-r_A;
v_BA=v_B-v_A;
w=w_mag*{0,0,1};
v_BA_wr=cross(w,r_BA);
v_BA_wr[1]=v_BA[1];

/*1st Method*/
alpha1_mag=-(a_B[1]-a_A[1]+r_BA[1]*w_mag^2)/r_BA[2];
alpha1=alpha1_mag*{0,0,1};

/*2nd Method*/
e_BA=r_BA/Modelica.Math.Vectors.norm(r_BA);
e_t=cross(k_hat,e_BA);
a_BA=a_B-a_A;
alpha2_mag=sum(e_t.*a_BA)/Modelica.Math.Vectors.norm(r_BA);
alpha2=alpha2_mag*{0,0,1};
w_2=cross(r_BA,v_BA)/sum(r_BA.*r_BA);

/*3rd Method*/
alpha3=cross(r_BA,a_BA)/sum(r_BA.*r_BA);
end Ex5_16;
