class Ex5_17
parameter Real theta_deg(unit="deg")=30;/*angle between AB and horizontal in degree unit*/
Real theta(unit="rad");/*angle between AB and horizontal in radian unit*/

parameter Real AB(unit="m")=2;/*length of AB*/
Real r_BA[3](each unit="m");/*position vector of B relative to A*/

Real w[3](each unit="rad/s");/*angular velocity of the mechanism*/
Real w_mag(unit="rad/s");/*magnitude of the angular velocity of the mechanism*/

parameter Real v_A[3](each unit="m/s")={0,-2,0};/*velocity vector of point A*/

Real v_B[3](each unit="m/s");/*velocity vector of point B*/
Real v_B_mag(unit="m/s");/*magnitude of velocity vector of point B*/
Real v_B_R[3](each unit="m/s");/*right hand side of relative velocity equation of point B*/

parameter Real a_A[3](each unit="m/s^2")={0,0,0};/*acceleration of point A*/
Real alpha_mag(unit="rad/s^2");/*magnitude of angular acceleration*/
Real alpha[3](each unit="rad/s^2");/*magnitude of angular acceleration*/

Real a_B[3](each unit="m/s^2");/*acceleration vector of point B*/
Real a_B_mag(unit="m/s");/*magnitude of acceleration vector of point B*/
Real a_B_R[3](each unit="m/s");/*right hand side of relative acceleration equation of point B*/

equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
r_BA=AB*{-cos(theta),-sin(theta),0};
w=w_mag*{0,0,1};
v_B=v_B_mag*{1,0,0};
v_B_R=v_A+cross(w,r_BA);
v_B[1]=v_B_R[1];
v_B[2]=v_B_R[2];

alpha=alpha_mag*{0,0,1};
a_B=a_B_mag*{1,0,0};
a_B_R=a_A+cross(alpha,r_BA)-w_mag^2*r_BA;

a_B[1]=a_B_R[1];
a_B[2]=a_B_R[2];

end Ex5_17;
