class Ex5_19
parameter Real v_A[3](each unit="m/s")={2,-3.5,0};/*linear velocity vector of point A*/
parameter Real v_B[3](each unit="m/s")={0.5,1,0};/*linear velocity vector of point B*/

parameter Real a_A[3](each unit="m/s^2")={3,7,0};/*acceleration vector of point A*/
parameter Real a_B[3](each unit="m/s^2")={-7.5,-6.5,0};/*acceleration velocity vector of point B*/

Real r_BA[3](each unit="m");/*position of B relative to A*/
Real v_BA[3](each unit="m/s");/*velocity vector of B relative to A*/
Real a_BA[3](each unit="m/s^2");/*acceleration vector of B relative to A*/

Real w[3](each unit="rad/s");/*angular velocity of the board*/
Real alpha[3](each unit="rad/s^2");/*angular acceleration of the board*/

equation
r_BA={1.5,0.5,0};
v_BA=v_B-v_A;
a_BA=a_B-a_A;

w=cross(r_BA,v_BA)/sum(r_BA.*r_BA);
alpha=cross(r_BA,a_BA)/sum(r_BA.*r_BA);

end Ex5_19;
