class Ex5_2
parameter Real pi = Modelica.Constants.pi;
parameter Real r_A(unit="mm")=600;/*radius of the pulley A*/
parameter Real r_B(unit="mm")=400;/*radius of the pulley B*/
parameter Real v_C0_mag(unit="mm/s")=1000;/*magnitude of the initial velocity of the block C*/
parameter Real a_C0_mag(unit="mm/s^2")=100;/*magnitude acceleration of the block C*/
parameter Real t1(unit="s")=8;/*given time to determine the acceleration of point D*/
parameter Real t2(unit="s")=10;/*given time to determine the number of revolutions of pully A*/

Real v_E0[3](each unit="mm/s");/*initial linaer velocity of point E*/
Real r_EA[3](each unit="mm");/*relative position vector from the center of A to E*/
Real w_A0[3](each unit="rad/s");/*initial angular velocity of A*/
Real w_A0_mag(unit="rad/s");/*magnitude of initial angular velocity of A*/
Real v_E_wr[3](each unit="mm/s");/*initial linaer velocity of point E from w_A0 and r_EA vector*/

Real a_Et[3](each unit="mm/s^2");/*tangential acceleration of point E*/
Real alpha_A[3](each unit="rad/s^2");/*angular acceleration of pully A*/
Real alpha_A_mag(unit="rad/s^2");/*magnitude of angular acceleration of pully A*/
Real a_Et_alphar[3](each unit="mm/s^2");/*tangential acceleration of point E from alpha_A and r_EA*/

Real r_DA[3](each unit="mm");/*relative position vector from the center of A to D*/
Real a_D0[3](each unit="mm/s^2");/*initial acceleration of point D*/
Real a_D0_mag(unit="mm/s^2");/*magnitude of initial acceleration of point D*/

Real w_A[3](each unit="rad/s");/*angular velocity of A after 8 seconds*/
Real a_D[3](each unit="mm/s^2");/*acceleration of point D after 8 seconds*/
Real a_D_mag(unit="mm/s^2");/*magnitude of acceleration of point D after 8 seconds*/

parameter Real theta_0(unit="rad")=0;/*initial angle made by pulley A*/
Real theta(unit="rad");/* total angle made by pulley A after 10 seconds due to the rotation*/
Real N;/*number of revolutions*/
equation
v_E0=v_C0_mag*{1,0,0};
r_EA=r_A*{0,1,0};
w_A0=w_A0_mag*{0,0,1};
v_E_wr=cross(w_A0,r_EA);
v_E_wr[1]=v_E0[1];

a_Et=a_C0_mag*{-1,0,0};
alpha_A=alpha_A_mag*{0,0,1};
a_Et_alphar=cross(alpha_A,r_EA);
a_Et_alphar[1]=a_Et[1];

r_DA=r_A*{1,0,0};
a_D0=cross(alpha_A,r_DA)+cross(w_A0,cross(w_A0,r_DA));
a_D0_mag=Modelica.Math.Vectors.norm(a_D0);

w_A=alpha_A*t1+w_A0;
a_D=cross(alpha_A,r_DA)+cross(w_A,cross(w_A,r_DA));
a_D_mag=Modelica.Math.Vectors.norm(a_D);

theta=(1/2)*alpha_A_mag*t2^2+w_A0_mag*t2+theta_0;
N=theta/(2*pi);
/*The  answer may slightly vary due to  rounding off values*/
end Ex5_2;
