class Ex5_24
/*the orientation of the coordinate system provided for position, velocity and acceleration in the book is wrong*/

parameter Real r_A[3](each unit="mm")={100,100,0};/*position vector of point A*/
parameter Real r_B[3](each unit="mm")={300,300,0};/*position vector of point B*/
parameter Real r_C[3](each unit="mm")={220,180,0};/*position vector of point C*/

parameter Real v_A[3](each unit="mm/s")={600,-400,100};/*linear velocity vector of point A*/
parameter Real v_B[3](each unit="mm/s")={200,0,0};/*linear velocity vector of point B*/
parameter Real v_C[3](each unit="mm/s")={440,-160,40};/*linear velocity vector of point C*/

parameter Real a_A[3](each unit="mm/s^2")={850,1200,-240};/*acceleration vector of point A*/
parameter Real a_B[3](each unit="mm/s^2")={200,200,0};/*acceleration velocity vector of point B*/
parameter Real a_C[3](each unit="mm/s^2")={420,760,-140};/*acceleration velocity vector of point C*/


Real r_BA[3](each unit="mm");/*position of B relative to A*/
Real r_CA[3](each unit="mm");/*position of C relative to A*/
Real v_BA[3](each unit="mm/s");/*velocity vector of B relative to A*/
Real v_CA[3](each unit="mm/s");/*velocity vector of C relative to A*/
Real a_BA[3](each unit="mm/s^2");/*acceleration vector of B relative to A*/
Real a_CA[3](each unit="mm/s^2");/*acceleration vector of C relative to A*/
Real q_BA[3](each unit="mm/s");
Real q_CA[3](each unit="mm/s");

/*1st Method*/
Real w[3](each unit="rad/s");/*angular velocity of the body*/
Real w_x(unit="ras/s");/*x-component of angular velocity vector of the body*/
Real w_y(unit="rad/s");/*y-component of angular velocity vector of the body*/
Real w_z(unit="rad/s");/*z-component of angular velocity vector of the body*/
Real v_BA_wr[3](each unit="mm/s");/*linaer velocity of B w.r.t to A from w and r_AB vector*/
Real v_CA_wr[3](each unit="mm/s");/*linaer velocity of C w.r.t to A from w and r_CA vector*/

Real alpha[3](each unit="rad/s^2");/*angular acceleration of the body*/
Real alpha_x(unit="ras/s^2");/*x-component of angular acceleration vector of the body*/
Real alpha_y(unit="rad/s^2");/*y-component of angular acceleration vector of the body*/
Real alpha_z(unit="rad/s^2");/*z-component of angular acceleration vector of the body*/
Real q_BA_wr[3](each unit="mm/s^2");/*q_BA from alpha and r_BA vector*/
Real q_CA_wr[3](each unit="mm/s^2");/*q_CA from alpha and r_CA vector*/

/*2nd Method*/
Real w_direct[3](each unit="rad/s");/*angular velocity of the body direct calculated from vector equation*/
Real alpha_direct[3](each unit="rad/s^2");/*angular acceleration of the body direct calculated from vector equation*/

equation
r_BA=r_B-r_A;
r_CA=r_C-r_A;
v_BA=v_B-v_A;
v_CA=v_C-v_A;
a_BA=a_B-a_A;
a_CA=a_C-a_A;

/*1st Method*/
w={w_x,w_y,w_z};
v_BA_wr=cross(w,r_BA);
v_BA_wr[1]=v_BA[1];
v_BA_wr[3]=v_BA[3];

v_CA_wr=cross(w,r_CA);
v_CA_wr[3]=v_CA[3];

q_BA=a_BA-cross(w,v_BA);
q_CA=a_CA-cross(w,v_CA);

alpha={alpha_x,alpha_y,alpha_z};

q_BA_wr=cross(alpha,r_BA);
q_BA_wr[1]=q_BA[1];
q_BA_wr[3]=q_BA[3];

q_CA_wr=cross(alpha,r_CA);
q_CA_wr[3]=q_CA[3];

/*2nd Method*/
w_direct=cross(v_BA,v_CA)/sum(v_BA.*r_CA);
alpha_direct=cross(q_BA,q_CA)/sum(q_BA.*r_CA);

end Ex5_24;
