class Ex5_26
parameter Real r_A[3](each unit="m")={10,0,10};/*position vector of point A*/
parameter Real r_B[3](each unit="m")={12,3,8};/*position vector of point B*/
parameter Real r_C[3](each unit="m")={10,4,13};/*position vector of point C*/

parameter Real v_A[3](each unit="m/s")={4,4,4};/*linear velocity vector of point A*/
parameter Real v_B[3](each unit="m/s")={3,10,12};/*linear velocity vector of point B*/
parameter Real v_C[3](each unit="m/s")={-3,-2,12};/*linear velocity vector of point C*/


Real r_BA[3](each unit="m");/*position of B relative to A*/
Real r_CA[3](each unit="m");/*position of C relative to A*/
Real v_BA[3](each unit="m/s");/*velocity vector of B relative to A*/
Real v_CA[3](each unit="m/s");/*velocity vector of C relative to A*/

Real w[3](each unit="rad/s");/*angular velocity of the body*/
Real e_w[3];/*unit vector along angular velocity*/
Real v_w[3](each unit="m/s");/*linear velocity of the body along the helical axis*/
Real v_pA[3](each unit="m/s");/*component of the velocity ofn A perpendicular to the helical axis*/

Real r_HA[3](each unit="m");/*position vector from A to a point on the helical axis*/
Real x_HA(unit="m");/*x-component of r_HA*/
Real y_HA(unit="m");/*y-component of r_HA*/
Real z_HA(unit="m");/*z-component of r_HA*/

Real v_PA_wr[3](each unit="m/s");/*velocity v_PA_wr using  w and r_HA vector*/

Real r_H[3](each unit="m");/*position vector to the point H in space*/
Real p_H_dasA[3](each unit="m");/*perpendicular vector from point A to a point H_das on the helical axis*/
Real r_HH[3](each unit="m");/*a vector between H and H_das*/

equation
r_BA=r_B-r_A;
r_CA=r_C-r_A;
v_BA=v_B-v_A;
v_CA=v_C-v_A;

w=cross(v_CA,v_BA)/sum(v_CA.*r_BA);
e_w=w/Modelica.Math.Vectors.norm(w);

v_w=sum(v_A.*e_w)*e_w;
v_pA=v_A-v_w;

r_HA={x_HA,y_HA,z_HA};

v_PA_wr=cross(w,r_HA);
z_HA=0;
v_PA_wr[1]=-v_pA[1];
v_PA_wr[2]=-v_pA[2];

r_H=r_A+r_HA;

p_H_dasA=cross(w,v_pA)/sum(w.*w);
r_HH=p_H_dasA-r_HA;

end Ex5_26;
