class Ex5_3
parameter Real theta_deg(unit="deg")=30;/*angular position of the block w.r.t. x-axis in degree unit(the value of theta is not given in the book, but we can get it by back calculation)*/
Real theta_rad(unit="rad");/*angular position of the block w.r.t. x-axis in radian unit*/

parameter Real r_mag(unit="m")=2;/*magnitude of the position vector of the block*/
Real r[3](each unit="m");/*position vector of the block*/
parameter Real a[3](each unit="m/s^2")={-3,0,0};/*acceleration vector of the block*/

Real e_r_hat[3];/*unit vector in the r-direction*/
parameter Real k_hat[3]={0,0,1};/*unit vector in the z-direction*/
Real e_t_hat[3];/*tangential unit vector*/
Real a_t(unit="m/s^2");/*tangential acceleration*/
Real alpha(unit="rad/s^2");/*angular acceleration*/

Real a_n(unit="m/s^2");/*normal acceleration*/
Real w(unit="rad/s");/*angular velocity*/
equation
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);
r=r_mag*{cos(theta_rad),sin(theta_rad),0};
e_r_hat=r/r_mag;
e_t_hat=cross(k_hat,e_r_hat);
a_t=sum(a.*e_t_hat);
r_mag*alpha=a_t;
a_n=sum(a.*e_r_hat);
r_mag*w^2=abs(a_n);

end Ex5_3;
