class Ex5_7
parameter Real r_A(unit="mm")=20;/*radius of the gear A*/
parameter Real r_B(unit="mm")=60;/*radius of the gear B*/
parameter Real r_C(unit="mm")=20;/*radius of the gear C*/
parameter Real r_D(unit="mm")=40;/*radius of the gear D*/
parameter Real w_A_mag(unit="rad/s")=4;/*magnitude of angular velocity of gear A*/
parameter Real alpha_A_mag(unit="rad/s^2")=2;/*magnitude of angular acceleration of gear A*/
Real alpha_A[3](each unit="rad/s^2");/*angular acceleration vector of gear A*/

Real r_PA[3](each unit="mm");/*position vector of P w.r.t. center of gear A*/
Real r_PB[3](each unit="mm");/*position vector of P w.r.t. center of gear B*/

Real w_A[3](each unit="rad/s");/*angular velocity of gear A*/
Real w_B[3](each unit="rad/s");/*angular velocity of gear B*/
Real w_B_mag(unit="rad/s");/*magnitude of angular velocity of gear B*/
Real v_P_A[3](each unit="mm/s");/*linear velocity of point P w.r.t. gear A*/
Real v_P_B[3](each unit="mm/s");/*linear velocity of point P w.r.t. gear B*/

Real r_QC[3](each unit="mm");/*position vector of Q w.r.t. center of gear C*/
Real r_QD[3](each unit="mm");/*position vector of Q w.r.t. center of gear D*/

Real w_C[3](each unit="rad/s");/*angular velocity of gear C*/
Real w_C_mag(unit="rad/s");/*magnitude of angular velocity of gear C*/
Real w_D[3](each unit="rad/s");/*angular velocity of gear D*/
Real w_D_mag(unit="rad/s");/*magnitude of angular velocity of gear D*/
Real v_Q_C[3](each unit="mm/s");/*linear velocity of point Q w.r.t. gear C*/
Real v_Q_D[3](each unit="mm/s");/*linear velocity of point Q w.r.t. gear D*/

Real alpha_B_mag(unit="rad/s^2");/*magnitude of angular acceleration of gear B*/
Real alpha_B[3](each unit="rad/s^2");/*angular acceleration vector of gear B*/

Real a_Pt_A[3](each unit="mm/s^2");/*tangential acceleration of point P w.r.t. gear A*/
Real a_Pt_B[3](each unit="mm/s^2");/*tangential acceleration of point P w.r.t. gear B*/

Real alpha_C_mag(unit="rad/s^2");/*magnitude of angular acceleration of gear C*/
Real alpha_C[3](each unit="rad/s^2");/*angular acceleration vector of gear C*/
Real alpha_D_mag(unit="rad/s^2");/*magnitude of angular acceleration of gear D*/
Real alpha_D[3](each unit="rad/s^2");/*angular acceleration vector of gear D*/

Real a_Qt_C[3](each unit="mm/s^2");/*tangential acceleration of point Q w.r.t. gear C*/
Real a_Qt_D[3](each unit="mm/s^2");/*tangential acceleration of point Q w.r.t. gear D*/
equation
r_PA=r_A*{0,1,0};
r_PB=r_B*{0,-1,0};
w_A=w_A_mag*{-1,0,0};
w_B=w_B_mag*{1,0,0};
v_P_A=cross(w_A,r_PA);
v_P_B=cross(w_B,r_PB);

v_P_A[3]=v_P_B[3];

r_QC=r_C*{0,-1,0};
r_QD=r_D*{-1,0,0};
w_C_mag=w_B_mag;
w_C=w_B;
w_D=w_D_mag*{0,1,0};
v_Q_C=cross(w_C,r_QC);
v_Q_D=cross(w_D,r_QD);

v_Q_C[3]=v_Q_D[3];

alpha_A=alpha_A_mag*{-1,0,0};
alpha_B=alpha_B_mag*{1,0,0};

a_Pt_A=cross(alpha_A,r_PA);
a_Pt_B=cross(alpha_B,r_PB);
a_Pt_A[3]=a_Pt_B[3];

alpha_C_mag=alpha_B_mag;
alpha_C=alpha_B;
alpha_D=alpha_D_mag*{0,1,0};

a_Qt_C=cross(alpha_C,r_QC);
a_Qt_D=cross(alpha_D,r_QD);
a_Qt_C[3]=a_Qt_D[3];


end Ex5_7;
