class Ex7_7
parameter Real m_A(unit="kg")=1;/*mass of the particle A*/
parameter Real m_B(unit="kg")=5;/*mass of the rod B*/
parameter Real l(unit="m")=2;/*length of the rod*/
parameter Real v_Ax(unit="m/s")=3;/*initial velocity of the the mass A*/
parameter Real v_Bx(unit="m/s")=0;/*initial velocity of the rod B*/
parameter Real w_B(unit="m/s")=0;/*initial angular velocity of the rod B*/
parameter Real e=1;/*coefficient of restitution*/
Real I_B(unit="kg.m^2");/*mass moment of inertia of the rod B*/

Real v_Ax_das(unit="m/s");/*final velocity of the the mass A after collision*/
Real v_Bx_das(unit="rad/s");/*final velocity of the rod B after collision*/
Real w_B_das(unit="rad/s");/*final angular velocity of the rod B after collision*/
equation
I_B=(1/12)*m_B*l^2;
m_A*v_Ax+m_B*v_Bx=m_A*v_Ax_das+m_B*v_Bx_das;
(l/2)*m_A*v_Ax+I_B*w_B=(l/2)*m_A*v_Ax_das+I_B*w_B_das;
v_Bx_das+(l/2)*w_B_das-v_Ax_das=e*(v_Ax-v_Bx-(l/2)*w_B);/*wrong notation of v_Ax has been used in the book*/
end Ex7_7;
