class Ex7_9
parameter Real pi = Modelica.Constants.pi;

parameter Real m_A(unit="lb-s^2/ft")=82.3;/*mass of the vehicle A(wrong unit is given in the book)*/
parameter Real I_A(unit="lb-ft^2")=1686;/*mass moment of inertia of the vehicle A(wrong unit is given in the book)*/
parameter Real r_PA[3](each unit="ft")={6,2,0};/*position vector of A*/
parameter Real v_A[3](each unit="ft/s")=73.3*{cos((10*pi)/180),-sin((10*pi)/180),0};/*initial velocity of car A(pi/180 has been multilied with 10 to convert the unit from degree to rad)*/
parameter Real w_A(unit="rad/s")=0;/*initial angular velocity of car A*/
 
parameter Real n_hat[3]={cos((5*pi)/180),sin((5*pi)/180),0};/*unit vector in the normal direction of contact surface(pi/180 has been multilied with 5 to convert the unit from degree to rad)*/
parameter Real e=0.8;/*coefficient of restitution*/

parameter Real m_B(unit="lb-s^2/ft")=87.6;/*mass of the vehicle B(wrong unit is given in the book)*/
parameter Real I_B(unit="lb-ft^2")=1795;/*mass moment of inertia of the vehicle B(wrong unit is given in the book)*/
parameter Real r_PB[3](each unit="ft")={-7,-2.2,0};/*position vector of B*/
parameter Real v_B[3](each unit="ft/s")={0,0,0};/*initial velocity of car B*/
parameter Real w_B(unit="rad/s")=0;/*initial angular velocity of car B*/

parameter Real k_hat[3]={0,0,1};/*unit vecor in the k-direction*/
Real t_hat[3];/*unit vector in the tangential direction of contact surface*/

Real v_At(unit="ft/s");/*tangential component of the initial velocity of car A*/
Real v_An(unit="ft/s");/*normal component of the initial velocity of car A*/
Real v_Bt(unit="ft/s");/*tangential component of the initial velocity of car B*/
Real v_Bn(unit="ft/s");/*normal component of the initial velocity of car B*/

Real X_A(unit="ft");
Real X_B(unit="ft");

Real v_An_das(unit="ft/s");/*normal component of the postimpact velocity of car A*/
Real v_Bn_das(unit="ft/s");/*normal component of the postimpact velocity of car B*/
Real w_A_das(unit="rad/s");/*postimpact angular velocity of car A*/
Real w_B_das(unit="rad/s");/*postimpact angular velocity of car B*/

Real v_A_das[3](each unit="ft/s");/*postimpact velocity of car A*/
Real v_B_das[3](each unit="ft/s");/*postimpact velocity of car B*/

Real A[4,4];
Real x[4];
Real b[4];

equation
t_hat=cross(k_hat,n_hat);

v_At=sum(v_A.*t_hat);
v_An=sum(v_A.*n_hat);
v_Bt=sum(v_B.*t_hat);
v_Bn=sum(v_B.*n_hat);

X_A=sum(k_hat.*(cross(r_PA,n_hat)));
X_B=sum(k_hat.*(cross(r_PB,n_hat)));

A=[m_A,     m_B,     0,   0;
   X_A*m_A, 0,      -I_A, 0;
   0,       X_B*m_B, 0,  -I_B;
  -1,       1,      -X_A, X_B];

b={m_A*v_An+m_B*v_Bn,
   X_A*m_A*v_An-I_A*w_A,
   X_B*m_B*v_Bn-I_B*w_B,
   e*(v_An+X_A*w_A-v_Bn-X_B*w_B)}; 
   
x=Modelica.Math.Matrices.solve(A,b);

x={v_An_das,v_Bn_das,w_A_das,w_B_das};
 
v_A_das=v_An_das*n_hat+v_At*t_hat;
v_B_das=v_Bn_das*n_hat+v_Bt*t_hat;
end Ex7_9;
