class Ex9_1
parameter Real pi = Modelica.Constants.pi;

parameter Real x_0(unit="mm")=10;/*initial deflection of the spring*/
parameter Real v_0(unit="mm")=0;/*initial velocity of the spring*/
parameter Real m(unit="kg")=49.2*10^(-3);/*mass of the system*/
parameter Real k(unit="N/m")=857.8;/*spring constant*/

Real w_n(unit="rad/s");/*natural frequency*/
Real f(unit="Hz");/*natural frequency in Hz*/
Real T(unit="s");/*period of the system*/
Real A(unit="mm");
Real v_max (unit="mm/s");/*maximum value of the velocity response*/
Real a_max (unit="mm/s^2");/*maximum value of the acceleration response*/
Real x(unit="mm");/*response of the system*/
equation
w_n=sqrt(k/m);
f=w_n/(2*pi);
T=(2*pi)/w_n;
A=sqrt(w_n^2*x_0^2+v_0^2)/w_n;
v_max=w_n*x_0;
a_max=w_n^2*x_0;
x=A*sin(w_n*time+pi/2);
end Ex9_1;
