class Ex9_11
parameter Real pi = Modelica.Constants.pi;
parameter Real k(unit="N/m")=2000;/*spring constant*/
parameter Real F_0(unit="N")=20;/*magnitude of the applied force*/
parameter Real f(unit="Hz")=10;/*frequency of the applied force in Hz*/
parameter Real x_max(unit="m")=0.1;/*maximum amplitude of vibration*/

Real f_0(unit="N/kg");/*magnitude of applied force per unit mass of the system*/
Real w_dr(unit="rad/s");/*frequency of the applied force in rad/s*/
Real w_n(unit="rad/s");/*frequency of the system*/
Real m(unit="kg",start=0.01);/*mass of the system*/
equation
f_0=F_0/m;
w_n^2=k/m;
w_dr=(2*pi)*f;
(2*f_0)/(w_n^2-w_dr^2)=x_max;

end Ex9_11;
