class Ex9_13
parameter Real f_0(unit="N/kg")=10;/*magnitude of applied force per unit mass of the system*/
parameter Real w_n(unit="rad/s")=132;/*natural frequency*/
parameter Real zeta=0.0085;/*damping ratio*/

/*1st case*/
parameter Real w_dr1(unit="rad/s")=132;/*frequency of the applied force*/
Real x_p1(unit="m");/*amplitude of the steady state response*/

/*2nd case*/
parameter Real w_dr2(unit="rad/s")=125;/*frequency of the applied force*/
Real x_p2(unit="m");/*amplitude of the steady state response*/
equation
x_p1=f_0/sqrt((w_n^2-w_dr1^2)^2+(2*zeta*w_n*w_dr1)^2);
x_p2=f_0/sqrt((w_n^2-w_dr2^2)^2+(2*zeta*w_n*w_dr2)^2);
end Ex9_13;
