class Ex9_14

parameter Real F_0(unit="N")=100;/*magnitude of the applied force*/
parameter Real w_dr(unit="rad/s")=2;/*frequency of the applied force*/
parameter Real w_n(unit="rad/s")=2;/*natural frequency of the system*/
parameter Real A_0(unit="m")=0.05;/*maximum deflection at steady state*/
parameter Real k(unit="N/m")=2000;/*stiffness of the machine*/

Real m(unit="kg");/*mass of the system*/
Real f_0(unit="N/kg");/*scaled force magnitude*/
Real zeta;/*damping ratio*/
Real c(unit="kg/s");/*damping constant*/

equation
w_n^2=k/m;
f_0=F_0/m;
zeta=c/(2*sqrt(k*m));
A_0=f_0/(2*zeta*w_n)^2;
end Ex9_14;
