class Ex9_6
parameter Real pi = Modelica.Constants.pi;

parameter Real g_L=10;/*ratio of g to L*/

/*For 1st set of initial condition(theta=pi rad and theta_dot=1 rad/s)*/
Real x1_a(unit="rad",start=pi);/*angular position of the pendulam(theta)*/
Real x2_a(unit="rad/s",start=1);/*angular velocity of the pendulam(theta_dot)*/

/*For 2nd set of initial condition(theta=1 rad and theta_dot=1 rad/s)*/
Real x1_b(unit="rad",start=1);/*angular position of the pendulam(theta)*/
Real x2_b(unit="rad/s",start=1);/*angular velocity of the pendulam(theta_dot)*/
equation
/*For 1st set of initial condition(theta=pi rad and theta_dot=1 rad/s)*/
der(x1_a)=x2_a;
der(x2_a)=-g_L*sin(x1_a);

/*For 1st set of initial condition(theta=pi rad and theta_dot=1 rad/s)*/
der(x1_b)=x2_b;
der(x2_b)=-g_L*sin(x1_b);


end Ex9_6;
