class Ex9_8
parameter Real pi = Modelica.Constants.pi;

parameter Real m(unit="kg")=100;/*mass of the system*/
parameter Real k(unit="N/m")=2000;/*spring constant*/
parameter Real c(unit="kg/s")=25;/*damping coefficent*/

Real w_n(unit="rad/s");/*natural frequency*/
Real zeta;/*damping ratio*/
Real w_d(unit="rad/s");/*damped natural frequency*/
Real T(unit="s");/*period of oscillation*/
equation
w_n=sqrt(k/m);
zeta=c/(2*sqrt(k*m));
w_d=w_n*sqrt(1-zeta^2);
T=(2*pi)/w_d;
/*the answer provided for T in the textbook is wrong*/
end Ex9_8;
