class Ex9_9
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real m(unit="kg")=100;/*mass of the system*/
parameter Real k(unit="N/m")=500;/*spring constant*/
parameter Real mu=0.3;/*coefficient of friction*/

/*For 1st set of initial condition(theta=pi rad and theta_dot=1 rad/s)*/
Real x_1(unit="m",start=0);/*initial position of the block*/
Real x_2(unit="m/s",start=0);/*initial velocity of the block*/

/*For 2nd set of initial condition(theta=1 rad and theta_dot=1 rad/s)*/
//Real x1_b(unit="m",start=5);/*initial position of the block*/
//Real x2_b(unit="m/s",start=0.0001);/*initial velocity of the block

equation
/*For 1st set of initial condition*/
der(x_1)=x_2;
der(x_2)=-0.5*x_1;

///*For 1st set of initial condition*/
//der(x1_b)=x2_b;
//der(x2_b)=-mu*m*g*(x2_b)-k*x1_b;
end Ex9_9;
