model Ex10_1

parameter Real T(unit="K")=300"temperature";
parameter Real Na(unit="cm^(-3)")=10^16"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);

Real Vt(unit="ev");
Real fi_fp(unit="V");
Real x_dT(unit="cm")"space charge width";


equation

Vt=(k*T)/e;
fi_fp=Vt*log(Na/ni);
x_dT=sqrt((4*epsilon_s*fi_fp)/(e*Na));



end Ex10_1;