model Ex10_3

parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real epsilon_ox(unit="F.cm^(-1)")=3.9*8.85*10^(-14);
parameter Real fi_ms(unit="V")=-1.1"Metal-semiconductor work function difference";
parameter Real Na(unit="cm^(-3)")=10^16"doping concentration";
parameter Real t_ox(unit="cm")=200*10^(-8)"thickness";
parameter Real Q_des_ss1(unit="C/cm^2")=5*10^10;


Real Cox(unit="F/cm^2")"capacitance";
Real Q_des_ss(unit="C/cm^2")"equivalent oxide charge density";
Real V_FB(unit="V")"flat-band voltage";

equation

Cox=epsilon_ox/t_ox;
Q_des_ss=Q_des_ss1*e;
V_FB=fi_ms-(Q_des_ss/Cox);

/*The  answer may slightly vary due to  rounding off values*/
end Ex10_3;