model Ex10_4

parameter Real T(unit="K")=300"temperature";
parameter Real Na(unit="cm^(-3)")=10^15"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
parameter Real epsilon_ox(unit="F.cm^(-1)")=3.9*8.85*10^(-14);
parameter Real t_ox(unit="cm")=120*10^(-8)"thickness";
parameter Real Q_des_ss(unit="C/cm^2")=10^10;
parameter Real fi_ms(unit="V")=-0.88"=fi_ms";

Real Vt(unit="ev");
Real fi_fp(unit="V");
Real x_dT(unit="cm")"space charge width";
Real QdesSD_max(unit="C/cm^2")"=|Q'SD(max)|";
Real V_TN(unit="V")"Threshold voltage";

equation

Vt=(k*T)/e;
fi_fp=Vt*log(Na/ni);
x_dT=sqrt((4*epsilon_s*fi_fp)/(e*Na));
QdesSD_max=e*Na*x_dT;
V_TN=(QdesSD_max-Q_des_ss*e)*(t_ox/epsilon_ox)+fi_ms+2*fi_fp;



end Ex10_4;