model Ex11_4


parameter Real T(unit="K")=300"temperature";
parameter Real Na(unit="cm^(-3)")=3*10^16"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
parameter Real epsilon_ox(unit="F.cm^(-1)")=3.9*8.85*10^(-14);
parameter Real t_ox(unit="cm")=200*10^(-8)"thickness";
parameter Real L(unit="cm")=10^(-4);
parameter Real delta_VT(unit="V")=0.2"shift in Threshold voltage";
parameter Real pi=Modelica.Constants.pi;
parameter Real sahi=pi/2;

Real Cox(unit="F/cm^2");
Real Vt(unit="ev");
Real fi_fp(unit="V");
Real x_dT(unit="cm")"space charge width";
Real W(unit="cm")"channel width";

equation

Cox=epsilon_ox/t_ox;
Vt=(k*T)/e;
fi_fp=Vt*log(Na/ni);
x_dT=sqrt((4*epsilon_s*fi_fp)/(e*Na));

W=-(e*Na*sahi*x_dT^2)/(Cox*delta_VT);

end Ex11_4;