model Ex12_10

parameter Real NB(unit="cm^(-3)")=10^16"base doping concentration";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
parameter Real Vpt(unit="V")=25"punch-through voltage";
parameter Real xBO(unit="cm")=0.5*10^(-4);

Real Nc(unit="cm^(-3)")"collector doping concentration";

equation

Vpt=(e*(xBO^2)*NB*(Nc+NB))/(2*epsilon_s*Nc);

end Ex12_10;