model Ex12_12

parameter Real T(unit="K")=300"temperature";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real Ic(unit="mA")=1"collector current";
parameter Real IB(unit="mA")=0.05"collector current";
parameter Real alpha_F=0.99;
parameter Real alpha_R=0.20;

Real Vt(unit="ev");
Real VCE_sat(unit="V")"collector-emitter saturation voltage";


equation

Vt=k*T/e;
VCE_sat=Vt*log((Ic*(1-alpha_R)+IB)*alpha_F/((alpha_F*IB-(1-alpha_F)*Ic)*alpha_R));

end Ex12_12;