model Ex12_14

parameter Real IE(unit="A")=10^(-3);
parameter Real xB(unit="cm")=0.5*10^(-4);
parameter Real xdc(unit="cm")=2.4*10^(-4);
parameter Real C_mu(unit="F")=10^(-13);
parameter Real Cs(unit="F")=10^(-13);
parameter Real C_je(unit="F")=10^(-12);
parameter Real Dn(unit="cm^2/s")=25;
parameter Real rc(unit="ohm")=20;
parameter Real bita=100;
parameter Real pi=Modelica.Constants.pi;
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real T(unit="K")=300"temperature";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real vs(unit="cm/s")=10^7;

Real rdes_e(unit="ohm");
Real To_e(unit="ps");
Real To_b(unit="ps");
Real To_d(unit="ps");
Real To_c(unit="ps");
Real To_ec(unit="ps");
Real f_bita(unit="MHz");
Real f_T(unit="Ghz");

equation

rdes_e=k*T/(e*IE);
To_e=rdes_e*C_je/10^(-12);
To_b=xB^2/(2*Dn*10^(-12));
To_d=xdc/(vs*10^(-12));
To_c=rc*(C_mu+Cs)/10^(-12);
To_ec=To_e+To_b+To_d+To_c;
f_T=1/(2*pi*To_ec*10^(-3));
f_bita=f_T*10^3/bita;


end Ex12_14;