model Ex12_6

parameter Real Jro(unit="A/cm^2")=10^(-8)"recombination factor";
parameter Real Jso(unit="A/cm^2")=10^(-11)"recombination factor";
parameter Real T(unit="K")=300"temperature";
parameter Real delta=0.9967;
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";

Real V_BE(unit="V")"forword bias B-E voltage";

equation

delta=1/(1+(Jro/Jso)*exp(-(e*V_BE)/(2*k*T)));

end Ex12_6;