model Ex12_9

parameter Real NE1(unit="cm^(-3)")=10^18"doping concentration";
parameter Real NE2(unit="cm^(-3)")=10^19"doping concentration";
parameter Real T(unit="K")=300"temperature";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real delta_Eg1(unit="ev")=0.020;
parameter Real delta_Eg2(unit="ev")=0.080;

Real p_EO1(unit="cm^(-3)")"=pEO for doping concentration = 10^18";
Real p_EO2(unit="cm^(-3)")"=pEO for doping concentration = 10^19";
Real p_EOdes1(unit="cm^(-3)")"=pEO' for doping concentration = 10^18";
Real p_EOdes2(unit="cm^(-3)")"=pEO' for doping concentration = 10^19";
Real ratio1"=pEO'/pEO for doping concentration = 10^18";
Real ratio2"=pEO'/pEO for doping concentration = 10^19";

equation

p_EO1=ni^2/NE1;
p_EO2=ni^2/NE2;
p_EOdes1=p_EO1*exp(delta_Eg1*e/(k*T));
p_EOdes2=p_EO2*exp(delta_Eg1*e/(k*T));
ratio1=exp(delta_Eg1*e/(k*T));
ratio2=exp(delta_Eg2*e/(k*T));
/*The  answer may slightly vary due to  rounding off values*/

end Ex12_9;