model Ex14_6

parameter Real alpha(unit="cm^(-1)")=10^3;
parameter Real fi_0(unit="cm^(-2)-s^(-1)")=10^17;
parameter Real W(unit="cm")=20*10^(-4);
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";

Real GL1(unit="cm^(-3)-s^(-1)")"generation rate of electron hole at the front edge";
Real GL2(unit="cm^(-3)-s^(-1)")"generation rate of electron hole at the back edge";
Real JL(unit="A/cm^2")"photocurrent density";

equation

GL1=alpha*fi_0;
GL2=alpha*fi_0*exp(-alpha*W);
JL=e*fi_0*(1-exp(-alpha*W));

end Ex14_6;