model Ex2_5
parameter Real h(unit="J.sec")=1.054*10^(-34);
parameter Real m(unit="kg")=9.11*10^(-31);
parameter Real a(unit="m")=3*10^(-10)"width";
parameter Real V0(unit="ev")=20"potential barrier";
parameter Real E(unit="ev")=2"energy";
parameter Real q(unit="coulombs")=1.6*10^(-19);
Real k2(unit="m^-1");
Real T;
equation
k2=sqrt((2*m*(V0-E)*q)/h^2);
T=16*(E/V0)*(1-E/V0)*exp(-2*k2*a);
end Ex2_5;