model Ex3_7


parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real E(unit="ev")=5.95"energy level";
parameter Real Ef(unit="ev")=6.25;
parameter Real q(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real fF_E=0.01"=fF(E)=probability that an energy state above Ef";
Real T(unit="K")"temperature";
Real kT(unit="ev");
equation

fF_E=(1-1/(1+exp(((E-Ef)/(kT)))));
kT=k*T/q;

end Ex3_7;