model Ex4_12

parameter Real T(unit="K")=300"temperature";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real Ec_Ef(unit="ev")=0.20"=Ec-Ef=Fermi energy";
parameter Real Nc(unit="cm^(-3)")=2.8*10^(19);
parameter Real Na(unit="cm^(-3)")=10^(16);
parameter Real q(unit="coulomb")=1.6*10^(-19)"Charge of electron";
Real kT(unit="ev");
Real Nd(unit="cm^(-3)")"=Nd";

equation

Nd-Na=Nc*exp(-((Ec_Ef)/(kT)));
kT=(k*T/q);

/*The  answer may slightly vary due to  rounding off values*/

end Ex4_12;