model Ex7_2

parameter Real T(unit="K")=300"temperature";
parameter Real Na(unit="cm^(-3)")=10^16"doping concentration";
parameter Real Nd(unit="cm^(-3)")=10^(15)"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
Real Vt(unit="ev");
Real Vbi(unit="V")"built-in potential barrier in a pn junction";
Real W(unit="cm")"space charge width";
Real xn(unit="cm");
Real xp(unit="cm");
Real Emax(unit="V/cm")"Electric field in a pn junction for zero bias";

equation

Vt=(k*T)/e;
Vbi=Vt*log((Na*Nd)/ni^2);
W=(((2*epsilon_s*Vbi)/e)*((Na+Nd)/(Na*Nd)))^(1/2);
xn=(((2*epsilon_s*Vbi)/e)*(Na/Nd)*(1/(Na+Nd)))^(1/2);
xp=(((2*epsilon_s*Vbi)/e)*(Nd/Na)*(1/(Na+Nd)))^(1/2);
Emax=-(e*Nd*xn)/epsilon_s;

/*The  answer may slightly vary due to  rounding off values*/
end Ex7_2;