model Ex7_3

parameter Real T(unit="K")=300"temperature";
parameter Real Na(unit="cm^(-3)")=10^16"doping concentration";
parameter Real Nd(unit="cm^(-3)")=10^(15)"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
parameter Real VR(unit="V")=5;
Real Vt(unit="ev");
Real Vbi(unit="V")"built-in potential barrier in a pn junction";
Real W(unit="cm")"space charge width";

equation

Vt=(k*T)/e;
Vbi=Vt*log((Na*Nd)/ni^2);
W=(((2*epsilon_s*(Vbi+VR))/e)*((Na+Nd)/(Na*Nd)))^(1/2);




end Ex7_3;