model Ex7_6

parameter Real T(unit="K")=300"temperature";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real Vbi(unit="V")=0.725"built-in potential barrier in a pn junction";
parameter Real slope(unit="(F/cm^2)^(-2)-(V)^(-1)")=6.15*10^15;
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);

Real Vt(unit="ev");
Real Na(unit="cm^(-3)")"doping concentration";
Real Nd(unit="cm^(-3)")"doping concentration";

equation

Nd=2/(e*epsilon_s*slope);
Vt=(k*T)/e;
Vbi=Vt*log((Na*Nd)/ni^2);

end Ex7_6;