model Ex8_1


parameter Real T(unit="K")=300"temperature";
parameter Real Na(unit="cm^(-3)")=6*10^15"doping concentration";
parameter Real Nd(unit="cm^(-3)")=10^(16)"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real Va(unit="V")=0.60"forword bias voltage";
Real n_po(unit="cm^(-3)")"thermal-equilibrium minority carrier concentration";
Real p_no(unit="cm^(-3)")"thermal-equilibrium minority carrier concentration";
Real np_xp(unit="cm^(-3)")"=np(-xp)  minority carrier concentration";
Real pn_xn(unit="cm^(-3)")"=pn(xn)   minority carrier concentration";

equation

n_po=ni^2/Na;
p_no=ni^2/Nd;
np_xp=n_po*exp((e*Va)/(k*T));
pn_xn=p_no*exp((e*Va)/(k*T));

/*The  answer may slightly vary due to  rounding off values*/

end Ex8_1;