model Ex8_2

parameter Real T(unit="K")=300"temperature";
parameter Real To_p0(unit="s")=5*10^(-7);
parameter Real To_n0(unit="s")=5*10^(-7);
parameter Real Na(unit="cm^(-3)")=10^16"doping concentration";
parameter Real Nd(unit="cm^(-3)")=10^(16)"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real Dn(unit="cm^2/s")=25;
parameter Real Dp(unit="cm^2/s")=10;
parameter Real epsilon_r=11.7;
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
Real Js(unit="A/cm^2")"reverse-saturation current density";


equation

Js=(e*ni^2)*((1/Na)*sqrt(Dn/To_n0)+(1/Nd)*sqrt(Dp/To_p0));

end Ex8_2;