model Ex8_6

parameter Real T(unit="K")=300"temperature";
parameter Real To_p0(unit="s")=5*10^(-7);
parameter Real To_n0(unit="s")=5*10^(-7);
parameter Real To_0(unit="s")=5*10^(-7);
parameter Real Na(unit="cm^(-3)")=10^16"doping concentration";
parameter Real Nd(unit="cm^(-3)")=10^(16)"doping concentration";
parameter Real ni(unit="cm^(-3)")=1.5*10^(10);
parameter Real Dn(unit="cm^2/s")=25;
parameter Real Dp(unit="cm^2/s")=10;
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
parameter Real VR(unit="V")=5;

Real Vt(unit="ev");
Real Vbi(unit="V")"built-in potential barrier in a pn junction";
Real W(unit="cm")"space charge width";
Real Js(unit="A/cm^2")"reverse-saturation current density";
Real Jgen(unit="A/cm^2")"The generation current density";
Real Jgen_Js"Ratio of the two current density";

equation

Js=(e*ni^2)*((1/Na)*sqrt(Dn/To_n0)+(1/Nd)*sqrt(Dp/To_p0));
Vt=(k*T)/e;
Vbi=Vt*log((Na*Nd)/ni^2);
W=(((2*epsilon_s*(Vbi+VR))/e)*((Na+Nd)/(Na*Nd)))^(1/2);
Jgen=(e*ni*W)/(2*To_0);
Jgen_Js=Jgen/Js;

/*The  answer may slightly vary due to  rounding off values*/

end Ex8_6;