model Ex8_7

parameter Real T(unit="K")=300"temperature";
parameter Real To_p0(unit="s")=10^(-7);
parameter Real I_p0(unit="A")=10^(-3)"current";
parameter Real I_DQ(unit="A")=10^(-3)"current";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
Real Vt(unit="ev");
Real Cd(unit="F")"Diffusion capacitance";
Real rd(unit="ohm")"Diffusion resistance";

equation

Vt=k*T/e;
Cd=I_p0*To_p0/(2*Vt);
rd=Vt/I_DQ;

/*The  answer may slightly vary due to  rounding off values*/

end Ex8_7;