model Ex9_2

parameter Real T(unit="K")=300"temperature";
parameter Real Nc(unit="cm^(-3)")=2.8*10^19"doping concentration";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real epsilon_s(unit="F.cm^(-1)")=11.7*8.85*10^(-14);
parameter Real derivative=4.4*10^13"=d(1/C')/dVR";
parameter Real Vbi(unit="V")=0.40"built-in potential barrier";

Real fi_n(unit="V");
Real Nd(unit="cm^(-3)")"doping concentration";
Real fi_Bn(unit="V")"actual schottky barrier height";
equation

derivative=2/(e*epsilon_s*Nd);
fi_n=(k*T/e)*log(Nc/Nd);
Vbi=fi_Bn-fi_n;

end Ex9_2;