model Ex9_6

parameter Real T(unit="K")=300"temperature";
parameter Real e(unit="coulomb")=1.6*10^(-19)"Charge of electron";
parameter Real k(unit="J.K^(-1)")=1.3807*10^(-23)"Boltzmann's constant";
parameter Real fi_Bn(unit="V")=0.67"actual schottky barrier height";
parameter Real Astar(unit="A/K^2-cm^2")=114"=A*=effective Richardson constant";
parameter Real J(unit="A/cm^2")=10"ideal reverse-saturation current density";
parameter Real JsT2(unit="A/cm^2")=3.66*10^(-11)"Schottky barrier for pn junction diode";
Real JsT1(unit="A/cm^2")"Schottky barrier diode";
Real Va1(unit="V")"forword bias voltage";
Real Va2(unit="V")"forword bias voltage";

equation

Astar=(JsT1/T^2)*exp((e*fi_Bn)/(k*T));
Va1=(k*T/e)*log(J/JsT1);
Va2=(k*T/e)*log(J/JsT2);
/*The  answer may slightly vary due to  rounding off values*/

end Ex9_6;